$(document).ready(function()
{
	common.show_main_view_intreface()
	common.show_errors_info()

	common.load_script('mcu_common.js')
	.then(() => common.load_script('network_settings.js'))
	.then(() => common.load_script('one_wire.js'))
	.then(() => common.load_script('app_sw.js'))
	.then(() => app_sw.main())
	.then(() => mcu_common.request_board_types())
	.then(text => common.response_ready(text))
	.then(values => {//new Promise(function(resolve, reject) {
		let product_code = values[0]
		let types = values.slice(1)
		let product_code_arr = get_set_value.ip2array(product_code)
		mcu_common.show_boards_types_setting()
		mcu_common.show_boards_by_type(types, product_code_arr)
		network_settings.show("old")
	})
	.then(() => one_wire.request_sensors())
	.then(text => common.response_ready(text))
	.then(values => {
		let sensors_ID = values.filter(element => element !== "0x0");
		one_wire.show(sensors_ID)

		common.on_page_loading_finished()
		user.parse_page()
	})
})

